SET NOCOUNT ON

DECLARE @STR_EXEC VARCHAR(2000)

SET @STR_EXEC = 'CREATE '

IF EXISTS(
	SELECT 
		ID 
	FROM 
		SYSOBJECTS 
	WHERE 
		NAME = 'V_TELE_ORC_CANCEL' AND XTYPE = 'V')
BEGIN
	SET	@STR_EXEC = 'ALTER '
END

	SET @STR_EXEC = @STR_EXEC + 'VIEW [DBO].[V_TELE_ORC_CANCEL]  
				AS  
				SELECT    
					 A.CD_FILIAL,   
					 A.CD_ORC,   
					 B.DTHR_ETAPA,   
					 F.DS_ETAPAS,   
					 E.DS_MOTIVO  
				FROM           
					 DBO.TELE_ORC AS A   
					 INNER JOIN DBO.TELE_ORC_ETAPA AS B ON   
						 A.CD_ORC = B.CD_ORC AND A.CD_ORC_ETAPA = B.CD_ORC_ETAPA  
					 INNER JOIN DBO.TELE_ORC_ETAPA_CANCEL AS C ON   
						 B.CD_ORC_ETAPA = C.CD_ORC_ETAPA   
					 INNER JOIN DBO.TELE_ORC_CANCEL AS D ON   
						 C.CD_CANCEL = D.CD_CANCEL   
					 INNER JOIN DBO.TELE_MOTIVO_CANCEL AS E ON   
						 D.CD_MOTIVO = E.CD_MOTIVO   
					 INNER JOIN DBO.TELE_TIPO_ETAPA AS F ON   
						 B.CD_ETAPAS = F.CD_ETAPAS  
				WHERE  
					 (A.CD_ETAPAS = 6 AND A.CD_TIPO = 1 )  AND
					 A.DTHR_PEDIDO > DATEADD(MONTH, -3, GETDATE()) AND
					 (DATEDIFF(MINUTE, B.DTHR_ETAPA, GETDATE()) <= (60 * CAST(DBO.UFD_PRC_EMP_CONFIG(1,''TV_TEMPO_VISUAL_PED_CANCELADO'',''6'') AS INT)))  
				UNION ALL
				SELECT  
					 A.CD_FILIAL,   
					 A.CD_ORC,   
					 B.DTHR_ETAPA,   
					 C.DS_ETAPAS,   
					 UPPER( B.OBS_ETAPA)  
				FROM           
					 DBO.TELE_ORC AS A   
					 INNER JOIN DBO.TELE_ORC_ETAPA AS B ON   
						 A.CD_ORC = B.CD_ORC AND A.CD_ORC_ETAPA = B.CD_ORC_ETAPA
					 INNER JOIN DBO.TELE_TIPO_ETAPA AS C ON   
						 B.CD_ETAPAS = C.CD_ETAPAS
				 WHERE  
					 (A.CD_ETAPAS = 13 AND A.CD_TIPO = 0) AND
					 A.DTHR_PEDIDO > DATEADD(MONTH, -3, GETDATE()) AND
					 (DATEDIFF(MINUTE, B.DTHR_ETAPA, GETDATE()) <= (60 * CAST(DBO.UFD_PRC_EMP_CONFIG(1,''TV_TEMPO_VISUAL_PED_CANCELADO'',''6'') AS INT))) '	
		
	EXEC (@STR_EXEC)